/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.EntityIDFunctionProvider;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u00028\u00000\u00012\u00020\u0003B\u0015\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/EntityIDColumnType;", "", "T", "Lorg/jetbrains/exposed/sql/ColumnType;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "sqlType", "()Ljava/lang/String;", "Lorg/jetbrains/exposed/dao/id/EntityID;", "valueFromDB", "(Ljava/lang/Object;)Lorg/jetbrains/exposed/dao/id/EntityID;", "Lorg/jetbrains/exposed/sql/Column;", "idColumn", "Lorg/jetbrains/exposed/sql/Column;", "getIdColumn", "()Lorg/jetbrains/exposed/sql/Column;", "<init>", "(Lorg/jetbrains/exposed/sql/Column;)V", "exposed-core"})
public final class EntityIDColumnType<T extends Comparable<? super T>>
extends ColumnType {
    @NotNull
    private final Column<T> idColumn;

    public EntityIDColumnType(@NotNull Column<T> idColumn) {
        Intrinsics.checkNotNullParameter(idColumn, (String)"idColumn");
        super(false, 1, null);
        this.idColumn = idColumn;
        if (!(this.idColumn.getTable() instanceof IdTable)) {
            boolean bl = false;
            String string = "EntityId supported only for IdTables";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Column<T> getIdColumn() {
        return this.idColumn;
    }

    @Override
    @NotNull
    public String sqlType() {
        return this.idColumn.getColumnType().sqlType();
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.idColumn.getColumnType().notNullValueToDB(value2 instanceof EntityID ? ((EntityID)value2).getValue() : value2);
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.idColumn.getColumnType().nonNullValueToString(value2 instanceof EntityID ? ((EntityID)value2).getValue() : value2);
    }

    @Override
    @NotNull
    public EntityID<T> valueFromDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return EntityIDFunctionProvider.INSTANCE.createEntityID(value2 instanceof EntityID ? ((EntityID)value2).getValue() : (Comparable)this.idColumn.getColumnType().valueFromDB(value2), (IdTable)this.idColumn.getTable());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.exposed.sql.EntityIDColumnType<*>");
        }
        EntityIDColumnType cfr_ignored_0 = (EntityIDColumnType)object2;
        return Intrinsics.areEqual(this.idColumn, ((EntityIDColumnType)other).idColumn);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.idColumn.hashCode();
    }
}

